#include <stdlib.h>
#include <string.h>

#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_ttf.h>
#include <SDL/SDL_mixer.h>
#include "typedef.h"
#include "interface.h"
#include "jeu.h"
#include "map.h"
#include "reseau.h"

#define RESOLUTION_X 800
#define RESOLUTION_Y 600

/// Fonctions diverses
    // Manipulation de chaine de caractre
    void ajouter_latin_1(char *str, char lettre, char *accent); //Ajoute un caractre latin-1  la chane
    char accentuer(char lettre, char accent); //Renvoie le caractre accentu ou 0 si la combinaison n'est pas gre
    void supprimer_caractere(char *str);// Supprime le dernier caractre d'une chaine.

int main ( int argc, char** argv )
{
    ///Variables Gnrales
    long n; // compteur lambda
    char str[255];
    SDL_Rect position;
    //long x,y; // compteurs de coordonnes

    Uint32 temps, dernier_affichage=0; //Permettent de ne pas saturer le processeur
    SDL_Event event;// Les evenements SDL

    /// Variables d'affichage (SDL)
    t_interface interface; // Structure de l'interface

    /// Variables de l'diteur de map
    interface.continuer = 1; // Pseudo-Boolen qui indique si on continue la boucle principale
    interface.pion = -1; // Tile actuelle de l'editeur
    interface.clic=0; // Etat du clic (gauche)
    interface.touche=0; // Touche actuellement enfonce
    interface.mousefocus=1; // Indique si le pointeur est dans la fenetre
    interface.appfocus=1;// Indique si la fenetre a le focus (clavier)
    interface.options.pseudo=NULL;
    interface.options.plein_ecran=0;
    interface.options.moonwalk=0;
    interface.options.poulette=0;
    interface.options.volume_son=128;
    interface.options.volume_musique=128;

    /// Variable du jeu
    t_partie jeu;// Structure contenant toute la partie
    t_serveur serv;

    /** Dfinition  du dossier en cours **/
/*    if(argc >= 1) //Si on a le nom du programme
    {
        strcpy(str, argv[0]);
        n = strlen(str);
        while((n > 0) && (str[n] != '\\') && (str[n] != '/')) {n--;} //On recherche le nom du dossier d'excution
        str[n] = 0; //On enlve le nom du programme
        chdir(str); //On se place dans le dossier d'excution
        str[0] = 0;
    }*/
    /** Fin **/

    if(!res_init(&serv)) {return EXIT_FAILURE;}
    sprintf(serv.dns, "localhost");
    /** Interprtation des arguments d'appel **/
    for(n = 1; n < argc; n++)
    {
        if(comparer_commande("-adresse=", argv[n])) //Si on demande de changer le port
        {
            sscanf(argv[n], "-adresse=%s", serv.dns);
        }
        else if(comparer_commande("-port=", argv[n])) //Si on demande de changer le port
        {
            sscanf(argv[n], "-port=%ld", &serv.port);
            if (serv.port == 0) {serv.port = PORT;}
        }
        else if(comparer_commande("-pseudo=", argv[n])) //Si on demande de changer le port
        {
            interface.options.pseudo=(char *)realloc(interface.options.pseudo,strlen(argv[n]+8)+1);
            sscanf(argv[n], "-pseudo=%s", interface.options.pseudo);
        }
        else if(comparer_commande("-f", argv[n])) //Si on demande de changer le port
        {
            interface.options.plein_ecran=1;
        }
        else if(comparer_commande("-volume_son=", argv[n])) //Si on demande de changer le port
        {
            sscanf(argv[n], "-volume_son=%ld", &interface.options.volume_son);
        }
        else if(comparer_commande("-volume_musique=", argv[n])) //Si on demande de changer le port
        {
            sscanf(argv[n], "-volume_musique=%ld", &interface.options.volume_musique);
        }
        str[0] = 0;
    }
    /** Fin de l'interprtation **/

    initialiser_affichage(&interface.fenetre,RESOLUTION_X,RESOLUTION_Y,interface.options.plein_ecran); // On initalise l'affichage, la SDL et les librairies utilises

    if (!initialiser_jeu(&interface,&jeu,&serv)) // On initialise le jeu
    {

        // Boucle principal du programme
        while (interface.continuer)
        {
            while (SDL_PollEvent(&event)) // On rcupre les venements
            {
                switch (event.type)// En fonction du type d'evenement
                {
                case SDL_QUIT: // Si on clique sur la petite croix (ou Alt+F4, etc...)
                    interface.continuer = 0; // On prcise qu'on veut quitter la boucle
                    break;
                case SDL_KEYDOWN: // Si une touche est vient d'tre enfonce
                    switch(event.key.keysym.sym) // On vrifie quelle touche a t enfonce
                    {
                        case SDLK_ESCAPE: // Si c'ets la touche Echapper
                            interface.continuer=0;  // On prcise qu'on veut quitter la boucle
                            break;
                        case SDLK_RETURN: //Si c'est la touche [Entre]
                            if (interface.gui_actif) // Si il y a un lement du GUI actif
                            {
                                if (interface.gui_actif->type==SAISIE) // Si c'est un element de type SAISIE
                                {
                                    effectuer_gui(interface.gui_actif->flag,&interface,&jeu,&serv); // On valide la saisie
                                }
                            }
                            // Sinon, on fait rien
                            break;
                        case SDLK_BACKSPACE: //Si c'est la touche [Effacer]
                            if (interface.gui_actif) // Si il y a un lement du GUI actif
                            {
                                if (interface.gui_actif->type==SAISIE)  // Si c'est un element de type SAISIE
                                {
                                    supprimer_caractere(interface.gui_actif->valeur); //On efface le dernier caractre (si possible)
                                }
                            }
                            // Sinon, on fait rien
                            break;
                        case SDLK_TAB: //Si c'est la touche [Effacer]
                            effectuer_gui(SWITCH_CMD,&interface,&jeu,&serv); // On valide la saisie
                            // Sinon, on fait rien
                            break;
                        default: // Pour n'importe quelle autre touche
                            interface.touche=event.key.keysym.sym;// On prcise qu'une touche est enfonce

                            if (interface.gui_actif)  // Si il y a un lement du GUI actif
                            {
                                if (interface.gui_actif->type==SAISIE)  // Si c'est un element de type SAISIE
                                {
                                    if(((event.key.keysym.unicode & 0xff00) == 0x00) && (event.key.keysym.unicode != 0) && !(event.key.keysym.mod & (KMOD_LCTRL|KMOD_RCTRL))) // Si la touche correspond  un caractre Latin-1
                                    {ajouter_latin_1(interface.gui_actif->valeur, event.key.keysym.unicode, &interface.accent);} // On rajoute ce caractre  la valeur du champ de saisie (en prcisant si un accent a t entr)
                                }
                            }
                            break;
                    }
                    break;
                case SDL_KEYUP: // Si on a relach une touche du clavier
                    interface.touche=0; // On prcise que la touche prcdemment enfonce ne l'est plus.
                    break;

                case SDL_MOUSEBUTTONDOWN:// Si on a cliqu sur un bouton de la souris
                    if (event.button.button == SDL_BUTTON_LEFT) // Si c'est le bouton gauche
                    {
                        interface.clic=1; // On prcise qu'un bouton est enfonc

                        for (n=0;n<interface.gui_taille;n++) // On va explorer tous les elements du GUI
                        {
                            if (interface.gui[n]->visible) // Si l'element est visible
                            {
                                if (event.button.x >= interface.gui[n]->position.x
                                && event.button.x <  interface.gui[n]->position.x+interface.gui[n]->crop.w
                                && event.button.y >= interface.gui[n]->position.y
                                && event.button.y <  interface.gui[n]->position.y+interface.gui[n]->crop.h
                                ) // Si le clic a lieu sur un element du GUI
                                {
                                    if (interface.gui[n]->type==BOUTON || interface.gui[n]->type==SAISIE) // Si l'element cliqu est un bouton ou un champ de saisie
                                    {
                                        interface.gui_actif=interface.gui[n]; // On rend cet element actif
                                    }
                                    else if (interface.gui[n]->type==SWITCH) // SI c'est un bouton switchable, on a un comportement spcifique
                                    {
                                        if (interface.gui_actif==interface.gui[n]) // Si l'element tait actif et considr comme l'element actif
                                        {
                                            interface.gui_actif->etat=INACTIF; // On le dclare inactif - Position OFF
                                            interface.gui_actif=0; // Et il n'y a plus d'element actif
                                        }
                                        else if (interface.gui[n]->etat==ACTIF) // Si son tat est ACTIF -> Position ON
                                        {
                                            interface.gui[n]->etat=INACTIF;  // On le dclare inactif - Position OFF
                                        }
                                        else // Sinon
                                        {
                                            interface.gui_actif=interface.gui[n]; // On le rend actif
                                            interface.gui_actif->etat=ACTIF; // Et son tat est aussi actif - Positon ON
                                        }
                                    }
                                }
                            }
                        }
                    }
                    break;

                case SDL_MOUSEBUTTONUP: // Si un bouton de la souris a t relach
                    if (event.button.button == SDL_BUTTON_LEFT)
                    {
                        interface.clic=0; // On dclare que le clic n'est plus enfonc

                        if (interface.gui_actif) // Si il y a un evenement actif
                        {
                            if (interface.gui_actif->visible
                            && event.button.x >= interface.gui_actif->position.x
                            && event.button.x <  interface.gui_actif->position.x+interface.gui_actif->crop.w
                            && event.button.y >= interface.gui_actif->position.y
                            && event.button.y <  interface.gui_actif->position.y+interface.gui_actif->crop.h ) // Si le clic avait eu lieu sur cet element
                            {
                                if (interface.gui_actif->type == BOUTON) // Si l'element est un bouton
                                {
                                    effectuer_gui(interface.gui_actif->flag,&interface,&jeu,&serv); // On effectue alors l'action dsigne par son flag
                                }
                            }
                            else // Si le clic a t relach en dehors de l'element prcedemment activ
                            {
                                interface.gui_actif=0; // alors on ne fait rien, et on le dsactive
                            }
                        }

                        if (   event.button.x >= interface.gui[0]->position.x
                            && event.button.x <  interface.gui[0]->position.x+interface.gui[0]->crop.w
                            && event.button.y >= interface.gui[0]->position.y
                            && event.button.y <  interface.gui[0]->position.y+interface.gui[0]->crop.h)
                        {
                            for (n=0;n<jeu.nbr_pions;n++)
                            {

                                position.x=jeu.pions[n].pos_x*TILE_TAILLE-interface.gui[0]->crop.x; // On transforme les coordonnes de la tile en coordonnes en pixels
                                position.y=jeu.pions[n].pos_y*TILE_TAILLE-interface.gui[0]->crop.y;   // On transforme les coordonnes de la tile en coordonnes en pixels

                                if (event.button.x >= position.x
                                 && event.button.x <  position.x+TILE_TAILLE
                                 && event.button.y >= position.y
                                 && event.button.y <  position.y+TILE_TAILLE)
                                {
                                    if (jeu.pions[n].joueur == jeu.joueur)
                                    {
                                        interface.pion=n;

                                        if( jeu.pions[n].type == CHEVALIER)
                                        {
                                            Mix_PlayChannel (-1, jeu.sons[n%2+3][rand()%15], 0);
                                        }
                                        else if (jeu.pions[n].type == ECLAIREUR || jeu.pions[n].type == PECORE)
                                        {
                                            Mix_PlayChannel (-1, jeu.sons[jeu.pions[n].type][rand()%15], 0);
                                        }

                                    }
                                }
                            }
                        }
                    }
                    break;
                case SDL_MOUSEMOTION: // Si le pointeur a t dplac
                    interface.pointeur.x = event.motion.x; // On enregistre la position du pointeur en x
                    interface.pointeur.y = event.motion.y; // On enregistre la position du pointeur en y
                    break;
                case SDL_ACTIVEEVENT: // Si il s'est produit un evenement relatif  la fenetre
                    if (event.active.state&SDL_APPMOUSEFOCUS) // Si l'evenement est un changement de focus souris
                    {
                            interface.mousefocus=event.active.gain; // On actualise le focus souris avec la nouvelle valeur
                    }
                    if (event.active.state&SDL_APPINPUTFOCUS) // Si l'evenement est un changement de focus clavier
                    {
                            interface.appfocus=event.active.gain; // On actualise le focus clavier avec la nouvelle valeur
                    }
                    break;
                }

            }

            if(interface.appfocus) // Si la fenetre a le focus clavier et souris
            {
                scroller_ecran(&interface,&jeu.map); // On scrolle l'ecran (si les conditions necessaires sont runies)
                bouger_pion(&interface, &serv, &jeu, interface.pion);
            }

            traiter_paquets(&interface, &serv, &jeu); //On traite les ventuels messages du serveur
            afficher_interface(&interface,&jeu); // On blitte ensuite les elements de l'interface

            //On effectue l'affichage rellement seulement aprs avoir attendu pour ne pas surcharger le processeur
            temps = SDL_GetTicks();
            if(temps - dernier_affichage < 50) {SDL_Delay(50 - (temps - dernier_affichage));} //On attend maximum 50 ms (-> 25 fps max.)
            dernier_affichage = temps;

            SDL_Flip(interface.fenetre); // On change l'ancien affichage avec le nouveau

        } // Fin de la Boucle principale
    }

    // On libre !!!
    res_quit(&serv);
    liberer_jeu(&jeu);
    liberer_map(&jeu.map); // On libre la map
    liberer_interface(&interface); // puis on libre l'interface
    liberer_affichage(interface.fenetre);

    // On retourne au menu
    system(CMD_LINE);
    return EXIT_SUCCESS; // Succs du programme
}

//Ajoute un caractre latin-1  la chane
void ajouter_latin_1(char *str, char lettre, char *accent)
{
    long utile; // Taille utile de la chaine de caractre

    utile = strlen(str); // Calcul de la taille utile

    if(utile < SAISIE_MAX - 1) //On vrifie s'il y a suffisament de place
    {
        if(*accent) //S'il y a un accent
        {
            str[utile] = accentuer(lettre, *accent); //On essaye d'accentuer la lettre
            if(str[utile] == 0) //Si a ne marche pas
            {
                str[utile] = *accent; //On place l'accent qui tait retenu
                if(utile < SAISIE_MAX - 2)
                {
                    utile++;
                    str[utile] = lettre; //Et on ajoute le nouveau caractre entr
                }
            }
            *accent = 0;
            utile++;
        }
        else
        {
            if((lettre == '^') || (lettre == '') || (lettre == '~')) {*accent = lettre;} //Si c'est un accent on le retient
            else
            {
                str[utile] = lettre; //Sinon on ajoute le caractre
                utile++;
            }
        }
    }
    str[utile] = 0; //On ajoute le caractre nul
    return;
}

 //Renvoie le caractre accentu ou 0 si la combinaison n'est pas gre
char accentuer(char lettre, char accent)
{
    //Tableaux constants contenant des lettres pouvant tre accentues
    const char voyelle[] = {'A', 'E', 'I', 'O', 'U', 'a', 'e', 'i', 'o', 'u', 'y'};
    const char circonflexe[] = {'', '', '', '', '', '', '', '', '', ''};
    const char trema[] = {'', '', '', '', '', '', '', '', '', '', ''};
    long i; //Compteur qui parcourt ces tableaux

    for(i = 0; i < sizeof(voyelle); i++) //Pour chaque lettre pouvant tre accentue
    {
        if(lettre == voyelle[i]) //Si la lettre  traiter est une lettre pouvant tre accentue
        {
            if(accent == '^' && i < sizeof(circonflexe)) {return circonflexe[i];} //Si l'accent voulu est circonflexe et qu'il existe une variante circonflexe de cette lettre, on renvoie la lettre avec l'accent circonflexe
            else if(accent == '' && i < sizeof(trema)) {return trema[i];} //Idem avec le trma
        }
    }
    //Cas particulier du tilde
    if(accent == '~' && lettre == 'N') {return '';}
    else if(accent == '~' && lettre == 'n') {return '';}
    //Sinon on ne peut pas combiner l'accent et la lettre
    return 0;
}

// Supprime le dernier caractre d'une chaine
void supprimer_caractere(char *str)
{
    long utile; // Taille utile de la chaine de caractre

    utile = strlen(str); // Calcul de la taille utile

    if(utile > 0) //On vrifie s'il y a suffisament de place
    {
        str[utile-1]=0; // On place le caractre EOT  la position prcdente
    }
    else // Sinon
    {
        str[0]=0; // On place le caractre EOT au dbut de la chaine de caractre
    }
    return;
}
